//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.IO;
using System.Xml;

namespace FrameworkLibraries
{
	public class ReadXmlFile
	{
		public static void Main(string [] args)
		{
			string document = "booklist.xml";
			ReadXmlFile readXml = new ReadXmlFile();
			if ( args.Length > 0 ) 
			{
				foreach(string arg in args)
					readXml.Process(arg);
			}
			else
				readXml.Process(document);
		}

		public void Process(String document)
		{
			XmlTextReader reader = null;
			try
			{
				// Zaadowanie pliku poprzez XmlTextReader
				Console.WriteLine ("Otwieranie pliku {0} ...", document);
				reader = new XmlTextReader (document);
				Console.WriteLine ("Plik {0} odczytany pomylnie ...", document);


				// Przetworzenie dostarczonego pliku XML
				Console.WriteLine ("Przetwarzanie ...");
				Console.WriteLine ();
				FormatXml(reader, document);
			}
			catch (Exception e)
			{
				Console.WriteLine ("Odczytanie pliku {0} nie powiodo si ", document);
				Console.WriteLine ("Wyjtek: {0}", e.ToString());

			}

			finally
			{
				Console.WriteLine();
				Console.WriteLine("Przetwarzanie pliku {0} zakoczone.", document);
				// Koniec pracy XmlTextReader
				if (reader != null)
					reader.Close();
			}
		}

		private static void FormatXml (XmlReader reader, string filename)
		{
			int declarationCount=0;
			int piCount=0;
			int docCount=0;
			int commentCount=0;
			int elementCount=0;
			int attributeCount=0;
			int textCount=0;
			int whitespaceCount=0;

			while (reader.Read())
			{
				switch (reader.NodeType)
				{
					case XmlNodeType.XmlDeclaration:
						Format (reader, "XmlDeclaration");
						declarationCount++;
						break;
					case XmlNodeType.ProcessingInstruction:
						Format (reader, "ProcessingInstruction");
						piCount++;
						break;
					case XmlNodeType.DocumentType:
						Format (reader, "DocumentType");
						docCount++;
						break;
					case XmlNodeType.Comment:
						Format (reader, "Comment");
						commentCount++;
						break;
					case XmlNodeType.Element:
						Format (reader, "Element");
						elementCount++;
						if (reader.HasAttributes)
							attributeCount += reader.AttributeCount;
						break;
					case XmlNodeType.Text:
						Format (reader, "Text");
						textCount++;
						break;
					case XmlNodeType.Whitespace:
						whitespaceCount++;
						break;
				}
			}

			// Wywietlenie statystyk pliku.
			Console.WriteLine ();
			Console.WriteLine("Statystyka pliku {0}", filename);
			Console.WriteLine ();
			Console.WriteLine("XmlDeclaration: {0}",declarationCount++);
			Console.WriteLine("ProcessingInstruction: {0}",piCount++);
			Console.WriteLine("DocumentType: {0}",docCount++);
			Console.WriteLine("Komentarz: {0}",commentCount++);
			Console.WriteLine("Element: {0}",elementCount++);
			Console.WriteLine("Atrybut: {0}",attributeCount++);
			Console.WriteLine("Tekst: {0}",textCount++);
			Console.WriteLine("Spacje: {0}",whitespaceCount++);
		}

		private static void Format(XmlReader reader, String nodeType)
		{
			// Formatowanie wyniku
			Console.Write(reader.Depth + " ");
			Console.Write(reader.AttributeCount + " ");
			for (int i=0; i < reader.Depth; i++)
			{
				Console.Write('\t');
			}

			Console.Write(reader.Prefix + nodeType + "<" + reader.Name + ">" + reader.Value);

			// Wywietlenie atrybutw dla biecego wza.
			if (reader.HasAttributes)
			{
				Console.Write(" Atrybuty:");

				for (int j=0; j < reader.AttributeCount; j++)
				{
					Console.Write(" [{0}] " + reader[j], j);
				}
			}
			Console.WriteLine();
		}

	}
}
